////////////////////////////////////////////////////////////////
//
// ImageBase.h - Bitmap handling basics
// ------------------------------------
// Version:   2003-05-25
// Maintain:  Michael Vinther         mv@logicnetdk
//
// Function return values:
//   0 : Ok
//   1 : Image unassigned
//   2 : Unable to open file
//   3 : Encoding/decoding error
//   4 : Unsupported pixel format
//   5 : Unable to close file (?)
//   6 : Operation not supported

#include <pastypes.h>

struct TImageContainer {
  int Width, Height;
  int BytesPerLine;
  int PixelFormat; // Se pfXXX constants below
  pbyte Map;
  pbyte Palette;   // 768 bytes: 256 color B,G,R
  pchar Options;
};

const pfText        = 0x00; // Map is a pointer to a 0-terminated string
const pf8bit        = 0x01; // If Palette is NULL when using this format, grayscale is assumed
const pf24bit       = 0x03; // Image Analyzer will always give 24 bit images in this format
const pf24bitPlanar = 0x13;
const pfComplex     = 0x28; // Complex matrix, two doubles per pixel: Re,Im
