//---------------------------------------------------------------------------
#ifndef SigmaPiHostH
#define SigmaPiHostH
// output masking options
#define omStandard 0
#define omForceSoft 1
#define omForceHard 2
// run filter ret. codes
#define rfNoErr 0
#define rfCrashed -1
#define rfCanceled 1
#define rfNotLoaded 2
#define rfNoEntryPoint 3
//---------------------------
// Progress func prototyp
//---------------------------
typedef void (* PROGRESSCALLBACK)(long, long);
//---------------------------
// HostRecord structure (data supplied by user)
//---------------------------
typedef struct HostRecord
        {
        bool has_bounding_rectangle;
        TRect filter_rect;
        Graphics::TBitmap *src_bitmap;
        Graphics::TBitmap *input_mask_bitmap;
        Graphics::TBitmap *output_mask_bitmap;
        int output_masking_option;
        TColor foreground_color;
        TColor background_color;
        PROGRESSCALLBACK progress_proc;
        HWND hWnd;
        char reserved[256];
        } HostRecord;
//---------------------------
// Function prototypes
//---------------------------
typedef void (* PROGRESSCALLBACK)(long, long);
typedef void (* ENUMCALLBACK)(char *);
typedef void __stdcall  (* HOSTABOUTFUNC)(void);
typedef void __stdcall (* HOSTCREATEFUNC)(void);
typedef void __stdcall (* HOSTDESTROYFUNC)(void);
typedef void __stdcall (* PLUGINABOUTFUNC)(HostRecord*);
typedef void __stdcall (* PLUGINENUMERATECBFFUNC)(char *, bool, ENUMCALLBACK );
typedef bool __stdcall (* PLUGINLOADFUNC)(char *, char *);
typedef int __stdcall (* PLUGINRUNBMPFUNC)(HostRecord*);
//---------------------------
HINSTANCE SigmaPiHost_DLL;
HOSTABOUTFUNC  sph_HostAbout;
HOSTCREATEFUNC sph_HostCreateObjects;
HOSTDESTROYFUNC sph_HostDestroyObjects;
PLUGINABOUTFUNC sph_PlugInAbout;
PLUGINENUMERATECBFFUNC sph_PlugInEnumerateCBF;
PLUGINLOADFUNC sph_PlugInLoad;
PLUGINRUNBMPFUNC sph_PlugInRunBMP;
//---------------------------
// Function for loading SigmaPiHost.DLL and filling structure
//---------------------------
void sph_HostLoad(const AnsiString DLLPath)
  {
  SigmaPiHost_DLL = LoadLibrary(AnsiString(DLLPath+"SigmaPiHost.DLL").c_str());
  sph_HostAbout = (HOSTABOUTFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_HostAbout");
  sph_HostCreateObjects = (HOSTCREATEFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_HostCreateObjects");
  sph_HostDestroyObjects = (HOSTCREATEFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_HostDestroyObjects");
  sph_PlugInAbout = (PLUGINABOUTFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_PlugInAbout");
  sph_PlugInEnumerateCBF = (PLUGINENUMERATECBFFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_PlugInEnumerateCBF");
  sph_PlugInLoad = (PLUGINLOADFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_PlugInLoad");
  sph_PlugInRunBMP = (PLUGINRUNBMPFUNC) GetProcAddress(SigmaPiHost_DLL, "DLL_PlugInRunBMP");
  }
void sph_HostUnLoad(void)
  {
  FreeLibrary(SigmaPiHost_DLL);
  }
#endif
