// AnalyzerPluginDemo.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"
#include "AnalyzerPluginDemo.h"
#include <stdlib.h>


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

TAnalyzerCallback AnalyzerCallback = NULL;


DLLExport(int) RegisterPlugin(TAnalyzerCallback CallBack)
{
  int Result;
  TMakeMenuItem Item;

  AnalyzerCallback = CallBack;
  Result = AnalyzerCallback!=NULL;


  if(Result)
  {
    Item.Menu = "Image";
    Item.Caption = "-";    
    Item.Hint = NULL;
    Result = AnalyzerCallback(cmdMakeMenuItem,&Item); // Insert menu separator
  }
  
  if(Result)
  {
    Item.Tag = 1;
    Item.Menu = "Plugins|Demo";
    Item.Caption = "Plugin demo 1";
    Item.Hint = "Create random image";
    Result = AnalyzerCallback(cmdMakeMenuItem,&Item);
  }

  if(Result)
  {
    Item.Tag = 2;
    Item.Menu = "Plugins|Demo";
    Item.Caption = "Plugin demo 2, invert image";
    Item.Hint = "Logical not";
    Result = AnalyzerCallback(cmdMakeMenuItem,&Item);
  }

  return Result;
}

DLLExport(int) ProcessImage(int Tag, TImageContainer *Image)
{
  switch(Tag)
  {
    case 1: // Plugin demo 1 item selected
      {
        TCreateImageWindow NewImageData;
        NewImageData.Name = "Image from plugin demo";
        NewImageData.Image.Width = 256;
        NewImageData.Image.Height = 256;
        NewImageData.Image.BytesPerLine = 256;
        NewImageData.Image.PixelFormat = pf8bit;
        NewImageData.Image.Palette = NULL; // Graysacle
        NewImageData.Image.Map = new byte[256*256];
        NewImageData.Image.Options = NULL;
        pbyte Pix = NewImageData.Image.Map;
        for(int i=0; i<256*256; i++, Pix++) // Create 256 x 256 random noise image
          *Pix = rand();
        AnalyzerCallback(cmdCreateImageWindow,&NewImageData);
        delete NewImageData.Image.Map;
      }

      HWND Handle;
      AnalyzerCallback(cmdGetMainWindowHandle,&Handle);
      MessageBox(Handle,"Plugin demo 1","Analyzer plugin demo",0);
      return 1;

    case 2: // Plugin demo 2 item selected
      switch(Image->PixelFormat)
      {
        case pf8bit:
        case pf24bit:
          {
            pbyte Pix = Image->Map;
            for(int i=0; i<Image->Height*Image->BytesPerLine; i++, Pix++)
              *Pix = ~*Pix;
            return 0;
          }
        default:
          return 4; // Unsupported pixel format
      }
  }
  return 6; // Operation not supported
}