////////////////////////////////////////////////////////////////
//
// Image Analyzer image processing plugin demo
// ---------------------
// Version:   2005-08-12
// Maintain:  Michael Vinther         mv@logicnetdk
//

#ifdef ANALYZERPLUGINDEMO_EXPORTS
#define DLLExport(type) __declspec(dllexport) type __stdcall
#else
#define DLLExport(type) __declspec(dllimport) type __stdcall
#endif

#include <imagebase.h>
#include <pastypes.h>

// Make menu item
const cmdMakeMenuItem = 1; // This command can only be issued from RegisterPlugin 
typedef struct 
{
  pchar Menu;
  pchar Caption;
  pchar Hint;
  int Tag;
} TMakeMenuItem;

// Open new image window
const cmdCreateImageWindow = 2;
typedef struct 
{
  pchar Name;
  TImageContainer Image;
} TCreateImageWindow;

// Get image from image window
const cmdGetImageWindow = 3;
typedef struct 
{
  int WindowNumber; 

  // Retunned by Analyzer:
  int TotalWindowCount;
  pchar Name;
  TImageContainer Image;
  RECT Selection;
} TGetImageWindow;

// Get handlw of main window
const cmdGetMainWindowHandle = 4;
typedef struct 
{
  HWND Handle;
} TGetMainWindowHandle;

// Update progress information and refresh screen
const cmdUpdateProgress = 5;
typedef struct 
{
  int Progress; // Set progress in %
} TUpdateProgress;

// Get program version number
const cmdGetProgramVersion = 6;
typedef struct 
{
  int Version; 
} TGetProgramVersion;

// Refresh children
const cmdRefreshChildren = 9;

// Function for sending cmdXXX commands to Image Analyzer
// TAnalyzerCallback function should return 0 on failure
typedef int (__stdcall *TAnalyzerCallback)(int Command, void *Data);  

// RegisterPlugin function should return 0 on failure
DLLExport(int) RegisterPlugin(TAnalyzerCallback CallBack);

// See return codes in ImageBase header
DLLExport(int) ProcessImage(int Tag, TImageContainer *Image);
